function C=readUCN(fname,trpstps,lays,rows,cols)
% C=readUCN(fname [,trpstps [,lays [,rows [,cols]]]]]])
% Read unformatted MT3DMS concentration file (UCN file)into struct 
% Equivalent to C-readMT3D(...)
%
% make subselections using the optional arguments
% they may be omittted as shown or used empty '' or [], for instance
%
%   C=readMT3D(fname,'',[1,3,6],'',3)
%
% fetches all transport time steps , layers 1,3 and 6, all rows  and column 3
%
%   C=readMT3D(fname,[1 3 5:8],'',3:10,12:21}
%
% fetches transport steps 1,3 and 5..8, all layers, rows 3..10 and
% columns 12..21
%
% C is a cell array whose length is the number of records in the file
% it has the following fields:
%    .values is a 3D array containing the requested concentration values
%    .label        label telling the contents
%    .trpstp       transport step number
%    .period       stress period number
%    .tstp         time step number within stress period
%    .time         time since begin of simulation
%    .NCOL         number of original columns in file fname
%    .NROW         number of original rows    in file fname
%    .NLAY         number of original layers  in file fname
%    .cols         list of fetched columns
%    .rows         list of fetched rows
%    .lays         list of fetched layers
%
% TO 090104 091214

% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

C=readMT3D(fname,trpstps,lays,rows,cols)
